/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component.path;

import com.fantasticsource.mctools.component.NBTSerializableComponent;
import com.fantasticsource.tools.component.CDouble;
import com.fantasticsource.tools.component.CInt;
import com.fantasticsource.tools.component.CLong;
import com.fantasticsource.tools.component.Component;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CPath
extends NBTSerializableComponent {
    public ArrayList<CPathTransform> transforms = new ArrayList();

    public CPath add(CPath path) {
        this.transforms.add(new CPathTransform(0, path));
        return this;
    }

    public CPath mult(CPath path) {
        this.transforms.add(new CPathTransform(1, path));
        return this;
    }

    public CPath rotate(CPath axisPath, CPath thetaPath) {
        this.transforms.add(new CPathTransform(2, axisPath, thetaPath));
        return this;
    }

    public CPath crossProduct(CPath other) {
        this.transforms.add(new CPathTransform(3, other));
        return this;
    }

    public CPath power(CPath other) {
        this.transforms.add(new CPathTransform(4, other));
        return this;
    }

    public CPath mod(CPath other) {
        this.transforms.add(new CPathTransform(5, other));
        return this;
    }

    public CPath posMod(CPath other) {
        this.transforms.add(new CPathTransform(6, other));
        return this;
    }

    public CPath lowLimit(CPath other) {
        this.transforms.add(new CPathTransform(7, other));
        return this;
    }

    public CPath highLimit(CPath other) {
        this.transforms.add(new CPathTransform(8, other));
        return this;
    }

    public CPath round() {
        this.transforms.add(new CPathTransform(9, new CPath[0]));
        return this;
    }

    public CPath floor() {
        this.transforms.add(new CPathTransform(10, new CPath[0]));
        return this;
    }

    public CPath ceil() {
        this.transforms.add(new CPathTransform(11, new CPath[0]));
        return this;
    }

    protected VectorN getRelativePositionInternal(long time) {
        return new VectorN(0.0, 0.0, 0.0);
    }

    public final VectorN getRelativePosition(long time) {
        VectorN result = this.getRelativePositionInternal(time);
        for (CPathTransform transform : this.transforms) {
            transform.applyTo(result, time);
        }
        return result;
    }

    public final VectorN getPosition(long time, VectorN origin) {
        VectorN relative = this.getRelativePosition(time);
        if (relative == null) {
            return null;
        }
        return origin.copy().add(relative);
    }

    @Override
    public CPath write(ByteBuf buf) {
        buf.writeInt(this.transforms.size());
        for (CPathTransform transform : this.transforms) {
            transform.write(buf);
        }
        return this;
    }

    @Override
    public CPath read(ByteBuf buf) {
        this.transforms.clear();
        for (int i = buf.readInt(); i > 0; --i) {
            this.transforms.add(new CPathTransform().read(buf));
        }
        return this;
    }

    @Override
    public CPath save(OutputStream stream) {
        new CInt().set(this.transforms.size()).save(stream);
        for (CPathTransform transform : this.transforms) {
            transform.save(stream);
        }
        return this;
    }

    @Override
    public CPath load(InputStream stream) {
        this.transforms.clear();
        for (int i = new CInt().load((InputStream)stream).value; i > 0; --i) {
            this.transforms.add(new CPathTransform().load(stream));
        }
        return this;
    }

    @Override
    public CPath copy() {
        return (CPath)super.copy();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.transforms.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (CPathTransform transform : this.transforms) {
                list.func_74742_a((NBTBase)transform.serializeNBT());
            }
            compound.func_74782_a("transforms", (NBTBase)list);
        }
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.transforms.clear();
        if (compound.func_74764_b("transforms")) {
            NBTTagList list = (NBTTagList)compound.func_74781_a("transforms");
            for (int i = 0; i < list.func_74745_c(); ++i) {
                CPathTransform transform = new CPathTransform();
                transform.deserializeNBT((NBTBase)list.func_150305_b(i));
                this.transforms.add(transform);
            }
        }
    }

    public static class CPathTransform
    extends NBTSerializableComponent {
        public static final int TYPE_ADD = 0;
        public static final int TYPE_MULT = 1;
        public static final int TYPE_ROTATE = 2;
        public static final int TYPE_CROSS_PRODUCT = 3;
        public static final int TYPE_POWER = 4;
        public static final int TYPE_MOD = 5;
        public static final int TYPE_POSMOD = 6;
        public static final int TYPE_LOW_LIMIT = 7;
        public static final int TYPE_HIGH_LIMIT = 8;
        public static final int TYPE_ROUND = 9;
        public static final int TYPE_FLOOR = 10;
        public static final int TYPE_CEIL = 11;
        public int type = 0;
        public CPath[] paths;

        public CPathTransform() {
        }

        public CPathTransform(int type, CPath ... paths) {
            this.type = type;
            this.paths = paths;
        }

        public void applyTo(VectorN vectorN, long time) {
            switch (this.type) {
                case 0: {
                    vectorN.add(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 1: {
                    vectorN.multiply(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 2: {
                    vectorN.rotate(this.paths[0].getRelativePosition(time), this.paths[1].getRelativePosition((long)time).values[0]);
                    break;
                }
                case 3: {
                    vectorN.crossProduct(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 4: {
                    vectorN.power(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 5: {
                    vectorN.mod(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 6: {
                    vectorN.posMod(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 7: {
                    vectorN.lowLimit(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 8: {
                    vectorN.highLimit(this.paths[0].getRelativePosition(time));
                    break;
                }
                case 9: {
                    vectorN.round();
                    break;
                }
                case 10: {
                    vectorN.floor();
                    break;
                }
                case 11: {
                    vectorN.ceil();
                }
            }
        }

        @Override
        public CPathTransform write(ByteBuf buf) {
            buf.writeInt(this.type);
            buf.writeInt(this.paths.length);
            for (CPath path : this.paths) {
                CPathTransform.writeMarked(buf, path);
            }
            return this;
        }

        @Override
        public CPathTransform read(ByteBuf buf) {
            CInt ci = new CInt();
            this.type = ci.read((ByteBuf)buf).value;
            this.paths = new CPath[ci.read((ByteBuf)buf).value];
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = (CPath)CPathTransform.readMarked(buf);
            }
            return this;
        }

        @Override
        public CPathTransform save(OutputStream stream) {
            new CInt().set(this.type).save(stream).set(this.paths.length).save(stream);
            for (CPath path : this.paths) {
                CPathTransform.saveMarked(stream, path);
            }
            return this;
        }

        @Override
        public CPathTransform load(InputStream stream) {
            CInt ci = new CInt();
            this.type = ci.load((InputStream)stream).value;
            this.paths = new CPath[ci.load((InputStream)stream).value];
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = (CPath)CPathTransform.loadMarked(stream);
            }
            return this;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("type", this.type);
            if (this.paths.length > 0) {
                NBTTagList list = new NBTTagList();
                for (CPath path : this.paths) {
                    list.func_74742_a((NBTBase)CPathTransform.serializeMarked(path));
                }
            }
            return compound;
        }

        public void deserializeNBT(NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            this.type = compound.func_74762_e("type");
            if (compound.func_74764_b("paths")) {
                NBTTagList list = (NBTTagList)compound.func_74781_a("paths");
                this.paths = new CPath[list.func_74745_c()];
                for (int i = 0; i < this.paths.length; ++i) {
                    this.paths[i] = (CPath)CPathTransform.deserializeMarked(list.func_150305_b(i));
                }
            } else {
                this.paths = new CPath[0];
            }
        }
    }

    public static class CPathData
    extends Component {
        public CPath path = null;
        public long startTime = 0L;
        public long pauseTime = -1L;
        public double rate = 1.0;

        public CPathData() {
        }

        public CPathData(CPath path) {
            this(path, System.currentTimeMillis());
        }

        public CPathData(CPath path, long startTime) {
            this.path = path;
            this.startTime = startTime;
        }

        public VectorN getRelativePosition() {
            return this.getRelativePosition(System.currentTimeMillis());
        }

        public VectorN getRelativePosition(long time) {
            if (this.pauseTime > -1L) {
                return this.path.getRelativePosition((long)((double)(this.pauseTime - this.startTime) * this.rate));
            }
            return this.path.getRelativePosition((long)((double)(time - this.startTime) * this.rate));
        }

        public CPathData pause() {
            return this.pause(System.currentTimeMillis());
        }

        public CPathData pause(long time) {
            this.pauseTime = time;
            return this;
        }

        public CPathData unpause() {
            return this.unpause(System.currentTimeMillis());
        }

        public CPathData unpause(long time) {
            if (this.pauseTime > -1L) {
                this.startTime += time - this.pauseTime;
                this.pauseTime = -1L;
            }
            return this;
        }

        @Override
        public CPathData write(ByteBuf buf) {
            CPathData.writeMarkedOrNull(buf, this.path);
            buf.writeLong(this.startTime);
            buf.writeLong(this.pauseTime);
            buf.writeDouble(this.rate);
            return this;
        }

        @Override
        public CPathData read(ByteBuf buf) {
            this.path = (CPath)CPathData.readMarkedOrNull(buf);
            this.startTime = buf.readLong();
            this.pauseTime = buf.readLong();
            this.rate = buf.readDouble();
            return this;
        }

        @Override
        public CPathData save(OutputStream stream) {
            CPathData.saveMarkedOrNull(stream, this.path);
            new CLong().set(this.startTime).save(stream).set(this.pauseTime).save(stream);
            new CDouble().set(this.rate).save(stream);
            return this;
        }

        @Override
        public CPathData load(InputStream stream) {
            CLong cl = new CLong();
            this.path = (CPath)CPathData.loadMarkedOrNull(stream);
            this.startTime = cl.load((InputStream)stream).value;
            this.pauseTime = cl.load((InputStream)stream).value;
            this.rate = new CDouble().load((InputStream)stream).value;
            return this;
        }
    }
}

